<x-app-layout>
    <x-slot name="header">
        Destination
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($destination->id)
                        Edit Destination
                        @else
                        Add New Destination
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($destination->id)
                        {{ route('admin.destination.update', $destination->id) }}
                    @else
                        {{ route('admin.destination.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($destination->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">Destination Name :</label>
                            <div class="">
                                <input type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $destination->name) }}" placeholder="Destination Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <x-location-picker
                            :selected-country="$destination->country ?? null"
                            :selected-state="$destination->state ?? null"
                            :selected-city="$destination->city ?? null"
                        />
                        <div class="row mb-4">
                            <x-dynamic-input
                                :items="$destination->places->pluck('name')->toArray()"
                                name="places"
                                placeholder="Enter a place"
                                buttonText="Add Place"
                            />
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="thumbnail">Banner Image :</label>
                            <div class="">
                                <input type="file" class="form-control @error('thumbnail') is-invalid @enderror" name="thumbnail"
                                    value="{{ old('thumbnail', $destination->thumbnail) }}" placeholder="Destination thumbnail"
                                    accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('thumbnail')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="description">Destination Details:</label>
                            <div class="">
                                <textarea name="description" class="content @error('description') is-invalid @enderror" placeholder="Destination description">{{ old('description', $destination->description) }}</textarea>
                            </div>
                            @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $destination->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.destination.index')}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
        <script>
            $(document).ready(function () {
            });
        </script>
    </x-slot>

</x-app-layout>
